﻿unit OS_WIN_Columns;

interface

uses
  {$IF DEFINED (ISFEXGUI)}
  GUI,
  {$IFEND}
  Columns, DataStorage, SysUtils;

function GetTable(const Name : string) : TSQL_Table_array;

implementation

function GetTable(const Name : string) : TSQL_Table_array;
const

  Array_Items_OS_WIN_BACKSTAGE: TSQL_Table_array = ( // Office 2016 BackstageInAppNavCache
    (sql_col: 'DNT_LastModified';              fex_col: 'Last Modified';          read_as: ftString;  convert_as: 'FTME'; col_type: ftDateTime;  show: True),
    (sql_col: 'DNT_Url';                       fex_col: 'URL';                    read_as: ftString;  convert_as: '';     col_type: ftString;    show: True),
    (sql_col: 'DNT_DisplayName';               fex_col: 'Display Name';           read_as: ftString;  convert_as: '';     col_type: ftString;    show: True),
    (sql_col: 'DNT_Author';                    fex_col: 'Author';                 read_as: ftString;  convert_as: '';     col_type: ftString;    show: True),
    );

  Array_Items_OS_WIN_PREFETCH: TSQL_Table_array = ( // Prefetch
    (sql_col: 'DNT_Filename';                  fex_col: 'Windows Prefetch Filename';              read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
    (sql_col: 'DNT_Filesize';                  fex_col: 'Windows Prefetch File size';             read_as: ftinteger; convert_as: '';   col_type: ftinteger;      show: True),
    (sql_col: 'DNT_Hash';                      fex_col: 'Windows Prefetch Hash';                  read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
    (sql_col: 'DNT_Execution Time (UTC)';      fex_col: 'Windows Prefetch Execution Time (UTC)';  read_as: ftString;  convert_as: '';   col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_Execution Count';           fex_col: 'Windows Prefetch Execution Count';       read_as: ftinteger; convert_as: '';   col_type: ftinteger;      show: True),
    (sql_col: 'DNT_Volume Name (1)';           fex_col: 'Windows Prefetch Volume Name';           read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
    (sql_col: 'DNT_Volume Serial (1)';         fex_col: 'Windows Prefetch Volume Serial';         read_as: ftString;  convert_as: '';   col_type: ftString;       show: True),
    (sql_col: 'DNT_Volume Creation (UTC) (1)'; fex_col: 'Windows Prefetch Volume Creation (UTC)'; read_as: ftString;  convert_as: '';   col_type: ftDateTime;     show: True));

  Array_Items_OS_WIN_PcaGeneralDb0: TSQL_Table_array = ( // Program Compatibility Assistant DB (Win11 - PcaGeneralDb0.txt)
    (sql_col: 'DNT_Execution_Date';            fex_col: 'Run Time';               read_as: ftString;  convert_as: '';     col_type: ftDateTime;  show: True),
    (sql_col: 'DNT_Run_Status';                fex_col: 'Run Status';             read_as: ftString;  convert_as: '';     col_type: ftString;    show: True),
    (sql_col: 'DNT_Executable_Path';           fex_col: 'Executable Path';        read_as: ftString;  convert_as: '';     col_type: ftString;    show: True),
    (sql_col: 'DNT_File_Description';          fex_col: 'File Description';       read_as: ftString;  convert_as: '';     col_type: ftString;    show: True),
    (sql_col: 'DNT_Software_Vendor';           fex_col: 'Software Vendor';        read_as: ftString;  convert_as: '';     col_type: ftString;    show: True),
    (sql_col: 'DNT_File_Version';              fex_col: 'File Version';           read_as: ftString;  convert_as: '';     col_type: ftString;    show: True),
    (sql_col: 'DNT_Program_ID';                fex_col: 'Program ID';             read_as: ftString;  convert_as: '';     col_type: ftString;    show: True),
    (sql_col: 'DNT_Exit_Code';                 fex_col: 'Exit Code';              read_as: ftString;  convert_as: '';     col_type: ftString;    show: True),
    );

  Array_Items_OS_WIN_PcaAppLaunchDict: TSQL_Table_array = ( // Program Compatibility Assistant Dic (Win11 - PcaAppLaunchDic.txt)
    (sql_col: 'DNT_Execution_Date';            fex_col: 'Execution Date';         read_as: ftString;  convert_as: '';     col_type: ftDateTime;  show: True),
    (sql_col: 'DNT_Program_Path';              fex_col: 'Program Path';           read_as: ftString;  convert_as: '';     col_type: ftString;    show: True),
    );

  Array_Items_OS_WIN_WIFI: TSQL_Table_array = ( // Windows Wifi
    (sql_col: 'DNT_name';                      fex_col: 'Wifi Name';                read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_connectionType';            fex_col: 'Connection Type';          read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_connectionMode';            fex_col: 'Connection Mode';          read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_authentication';            fex_col: 'Authentication';           read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_encryption';                fex_col: 'Encryption';               read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_useOneX';                   fex_col: 'Use OneX';                 read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_keyType';                   fex_col: 'Key Type';                 read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_protected';                 fex_col: 'Protected';                read_as: ftString;       convert_as: '';            col_type: ftString;       show: True));

  Array_Items_OS_WIN_TIMELINE: TSQL_Table_array = ( // Windows 10 TimeLine (Activity table)
    (sql_col: 'DNT_AppID';                     fex_col: 'AppId';                    read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_PackageIdHash';             fex_col: 'PackageIdHash';            read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_AppActivityId';             fex_col: 'AppActivityId';            read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_ActivityType';              fex_col: 'Activity Type';            read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_LastModifiedTime';          fex_col: 'Last Modified Time';       read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_ExpirationTime';            fex_col: 'Expiration Time';          read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_Payload';                   fex_col: 'Payload';                  read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_PlatformDeviceId';          fex_col: 'Platform Device ID';       read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_CreatedInCloud';            fex_col: 'Created In Cloud';         read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_StartTime';                 fex_col: 'Start Time';               read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_EndTime';                   fex_col: 'End Time';                 read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_LastModifiedOnClient';      fex_col: 'Last Modified On Client';  read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_ETag';                      fex_col: 'ETag';                     read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_SQLLOCATION';               fex_col: 'Location';                 read_as: ftString;       convert_as: '';            col_type: ftString;       show: True));

  Array_Items_OS_WIN_TIMELINE_ACTIVITIYOPERATION: TSQL_Table_array = ( // Windows 10 TimeLine (ActivityOperation table) https://docs.microsoft.com/en-us/graph/api/resources/projectrome-historyitem?view=graph-rest-1.0
    (sql_col: 'DNT_OperationOrder';            fex_col: 'Operation Order';          read_as: ftInteger;      convert_as: '';            col_type: ftInteger;      show: True),
    (sql_col: 'DNT_OperationType';             fex_col: 'Operation Type';           read_as: ftInteger;      convert_as: '';            col_type: ftInteger;      show: True),
    (sql_col: 'DNT_AppID';                     fex_col: 'AppId';                    read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_PackageIdHash';             fex_col: 'PackageIdHash';            read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_AppActivityId';             fex_col: 'AppActivityId';            read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_ActivityType';              fex_col: 'Activity Type';            read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_LastModifiedTime';          fex_col: 'Last Modified Time';       read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_ExpirationTime';            fex_col: 'Expiration Time';          read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_Payload';                   fex_col: 'Payload';                  read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_CreatedTime';               fex_col: 'Created Time';             read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_OperationExpirationTime';   fex_col: 'Operation Expiration Time';read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_PlatformDeviceId';          fex_col: 'Platform Device ID';       read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_CreatedInCloud';            fex_col: 'Created In Cloud';         read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_StartTime';                 fex_col: 'Start Time';               read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_EndTime';                   fex_col: 'End Time';                 read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_LastModifiedOnClient';      fex_col: 'Last Modified On Client';  read_as: ftLargeInt;     convert_as: 'UNIX';        col_type: ftDateTime;     show: True),
    (sql_col: 'DNT_ETag';                      fex_col: 'ETag';                     read_as: ftString;       convert_as: '';            col_type: ftString;       show: True),
    (sql_col: 'DNT_SQLLOCATION';               fex_col: 'Location';                 read_as: ftString;       convert_as: '';            col_type: ftString;       show: True));

Array_Items_NULL: TSQL_Table_array = (
  (sql_col: '';
  fex_col: '';
  read_as: ftString;
  convert_as: '';
  col_type: ftString;
  show: false));

begin
  if Name = 'OS_WIN_BACKSTAGE'                   then Result := Array_Items_OS_WIN_BACKSTAGE else
  if Name = 'OS_WIN_PREFETCH'                    then Result := Array_Items_OS_WIN_PREFETCH else
  if Name = 'OS_WIN_PcaGeneralDb0'               then Result := Array_Items_OS_WIN_PcaGeneralDb0 else
  if Name = 'OS_WIN_PcaAppLaunchDict'            then Result := Array_Items_OS_WIN_PcaAppLaunchDict else
  if Name = 'OS_WIN_WIFI'                        then Result := Array_Items_OS_WIN_WIFI else
  if Name = 'OS_WIN_TIMELINE'                    then Result := Array_Items_OS_WIN_TIMELINE else
  if Name = 'OS_WIN_TIMELINE_ACTIVITIYOPERATION' then Result := Array_Items_OS_WIN_TIMELINE_ACTIVITIYOPERATION else
  begin
    Result := Array_Items_NULL;
    {$IF DEFINED (ISFEXGUI)}
    ShowMessage('OS_WIN_Columns' + ':' + #13#10 + #13#10 + 'Did not locate artifact column layout:' + #13#10 + #13#10 + Name);
    {$IFEND}
    Progress.Log(format('%-54s %-100s', ['Error: Did not locate artifact column layout:', Name]));
  end;
end;
end.
